#include <sun/a.out.h>
#include <sun/stab.h>
#include <ctype.h>
#include "symtab.h"
#include "dtype.h"
#include "symbol.h"
#include "sunossymtab.h"
#include "core.h"
SRCFILE("sunossymtab.c")

int ccdemangle(char**,char* =0,int =0);
void SymbolStats();

SunosSymTab::SunosSymTab(Core* c, int fd, SymTab *i, long r)
 :SymTab(c, fd, i, r)
{
}

SunosSymTab::~SunosSymTab()
{
	delete hdr;
	delete sunosshare;
}

char *SunosSymTab::gethdr()
{
	hdr = new exec;
	if( lseek( fd, 0L, 0 ) == -1 || !ReadOK(fd, (char*)hdr, sizeof *hdr) )
		return SysErr( "symbol table: " );
	_magic = hdr->a_magic;
	if( N_BADMAG(*hdr) )
		return "symbol table: not executable text";
	entries = hdr->a_syms/sizeof(nlist);
	return 0;
}

Block *SunosSymTab::gatherfunc(Func *func)
{
	register struct nlist *n;
	register Block *ablk, *lblk;
	Var *arg = 0, *lcl = 0;
	register Stmt *stmt = 0;
	long bfun = func->begin, size = func->size;
	char *so = func->source()->_text;
	SunosSource *src = (SunosSource *)func->typeinfo;
	SunosType *suntype = src->typeinfo;
	char *subtype;
	int regarg = 0;
	long value;
	DType *t;
	struct nlist *f, *ne;

	++FunctionGathered;
	SymbolStats();
	IF_LIVE( bfun < 0 || bfun+size > entries ) return 0;
	if (size == 0)
		return fakeblk();
	if( !(n = f = nlistvector(bfun,size+1)) ) return 0;
	IF_LIVE( n->n_type != N_FUN ) return 0;
	ablk = new Block( this, 0, 0, sf("%s().arg_blk",n->n_un.n_name) );
	lblk = new Block( this, ablk, 0, sf("%s().lcl_blk",n->n_un.n_name) );
	ablk->child = lblk;
	ablk->range.hi = ablk->range.lo = func->range.lo;
	long ininclude = 0;
	int issparc = hdr->a_machtype == M_SPARC;
	for(ne = n + size; n < ne; n++ ){
		switch( n->n_type ){
		case N_PSYM:
			// If register arg, ignore non-reg entry
			if (issparc && (n+1)->n_type == N_RSYM) {
				regarg = 1;
				break;
			}
			gathervar( n, &arg, ablk, U_ARG, suntype );
			// Symbol table lies about structures passed as args
			if (issparc && arg->type.isstrun()) {
				t = new DType(arg->type);
				arg->type = t->incref();
			}
			break;
		case N_LSYM:
			subtype = strchr(n->n_un.n_name, ':');
			if (!subtype ||
			    (subtype[1] != '(' && !isdigit(subtype[1])))
				break;
			gathervar( n, &lcl, lblk, U_AUT, suntype, subtype );
			break;
		case N_STSYM:
		case N_LCSYM:
			subtype = strchr(n->n_un.n_name, ':');
			if (!subtype || subtype[1] != 'V')
				break;
			n->n_value += relocation;
			gathervar( n, &lcl, lblk, U_STA, suntype, subtype );
			break;
		case N_RSYM:
			subtype = strchr(n->n_un.n_name, ':');
			if (!subtype)
				break;
			if (issparc && subtype[1] == 'p') {
				regarg = 1;	// Sun's unbundled ANSI cc
				break;
			}
			if (regarg) {
				regarg = 0;
				gathervar(n, &arg, ablk,U_REG,suntype,subtype);
				if (arg->type.isstrun()) {
					t = new DType(arg->type);
					arg->type = t->incref();
				}
			} else
				gathervar(n, &lcl, lblk,U_REG,suntype,subtype);
			break;
		case N_SOL:
			if (!strcmp(n->n_un.n_name, so))
				ininclude = 0;
			else
				ininclude = 1;
			break;
		case N_SLINE:
			if (ininclude)
				break;
			value = n->n_value + relocation;
			if (stmt)
				stmt->range.hi = value;
			stmt = new Stmt(this,lblk,stmt);
			if( !ablk->stmt ) ablk->stmt = stmt;
			stmt->lineno = n->n_desc;
			stmt->range.lo = value;
			break;
		}
	}
	if (func->range.hi) {
		if (stmt) stmt->range.hi = func->range.hi;
		ablk->range.hi = func->range.hi;
	} else if (stmt) {
		stmt->range.hi = stmt->range.lo + 20;
		ablk->range.hi = stmt->range.lo;
	}
	delete [] f;
	uncfront( ablk->var, (char *)0 );
	uncfront( lblk->var, (char *)0 );
	return ablk;
}

void SunosSymTab::gathervar(nlist *n,Var **v, Block *b, UDisc d, SunosType *bt,char *marker)
{
	IF_LIVE( !v ) return;
	if( *n->n_un.n_name == ' ')
		return;
	if (!marker && !(marker = strchr( n->n_un.n_name, ':')))
		return;
	*marker++ = 0;
	*v = new Var( this, b, *v, d, n->n_un.n_name );
	if( b && !b->var ) b->var = *v;
	(*v)->range.lo = n->n_value;
	(*v)->type = bt->gettype(marker);
}

void SunosSymTab::gathervar( nlist *n, Var **v, Block *b, UDisc d)
{
	DType dt;

	IF_LIVE( !v ) return;
	*v = new Var( this, b, *v, d, n->n_un.n_name );
	if( b && !b->var ) b->var = *v;
	(*v)->range.lo = n->n_value;
	(*v)->type = dt;
	(*v)->type.pcc = n->n_desc;
}

char *SunosSymTab::gettbl()
{
	base = new nlist[entries];
	symoff = N_SYMOFF(*hdr);
	if( lseek(fd, symoff, 0) == 1
	 || !ReadOK(fd, (char*)base, (int)hdr->a_syms)
	 || !ReadOK(fd, (char*)&strsize, 4) ){
		delete [] base; base = 0;
		return SysErr( "symbol table: " );
	}
	strings = new char[strsize];
	if( lseek( fd, -4, 1 ) == -1 || !ReadOK(fd, strings, (int)strsize) ){
		delete [] strings; strings = 0;
		delete [] base; base = 0;
		return SysErr( "strings table: " );
	}
	strcpy( strings, "???" );	/* zero string index */
	return 0;
}

Source *SunosSymTab::tree()
{
	register nlist	*n, *base_entries, *n2;
	SunosSource	*src = 0, *lsrc = 0, *hsrc = 0;
	Func		*func = 0;
	Block		*fake = fakeblk();
	Var		*glb = 0, *fst = 0, *resolve;
	register long	regstrings, inafunc = 0, inasrc = 0;
	long		lastline = 1, lgfound = 0;
	char		*equal, *subtype, *cp;
	char		*name, *directory = 0;
	char		*lastsol;
	SunosType	*suntype = 0;
	DType		*t;
	int		ininclude = 0;
	int		demangled;
	
	if( _warn = gettbl() ) return 0;
	base_entries = base+entries;
	regstrings = (long) strings;
	glb = globregs(_blk, _core->nregs() );
	sunosshare = new SunosTShare;
	for( n = base; n < base_entries; ++n ){
		n->n_un.n_strx += (long) regstrings;
		if( inasrc && n->n_un.n_name && (equal = strchr(n->n_un.n_name, '=')))
			suntype->parsetype(equal, n->n_un.n_name);
		switch( n->n_type ){
		case N_ABS|N_EXT:
			if( n->n_un.n_name[0] != '_' ) break;	/* ? */
		case N_BSS|N_EXT:
		case N_DATA|N_EXT:
			if( *n->n_un.n_name == '_' ) ++n->n_un.n_name;
			ccdemangle(&n->n_un.n_name);
			resolve = (Var*)idtosym(U_GLB, n->n_un.n_name, 0);
			n->n_value += relocation;
			if( resolve ){
				if( !resolve->range.lo )
					resolve->range.lo = n->n_value;
			} else {
				n->n_desc = LONG;
				gathervar( n, &glb, _blk, U_GLB );
				break;
			}
			break;
		case N_GSYM:
			if (!inasrc)
				break;
			if (!(subtype = strchr(n->n_un.n_name, ':')))
				break;
			*subtype = 0;
			ccdemangle(&n->n_un.n_name);
			if (!idtosym(U_GLB, n->n_un.n_name, 0)) {
				n->n_value += relocation;
				gathervar(n,&glb,_blk,U_GLB,suntype,subtype);
			}
			break;
		case N_LCSYM:
		case N_STSYM:
			if (!inasrc || !src)
				break;
			if (!(subtype = strchr(n->n_un.n_name, ':')))
				break;
			if (subtype[1] != 'S')
				break;
			n->n_value += relocation;
			gathervar(n,&fst,src->blk,U_FST,suntype,subtype);
			break;
		case N_SLINE:
			if (!ininclude && n->n_desc > 0)
				lastline = n->n_desc;
			break;
		case N_BINCL:	// Include files for type indexing
			suntype->addinclude(n->n_un.n_name, 1, n->n_value);
			break;
		case N_EXCL:
			suntype->addinclude(n->n_un.n_name, 0, n->n_value);
			break;
		case N_SOL:
			name = n->n_un.n_name;
			if (!strcmp(name, src->_text))
				lastsol = 0;
			else
				lastsol = name;
			if (!inafunc || !strcmp(name, hsrc->_text))
				ininclude = 0;
			else
				ininclude = 1;
			break;
		case N_SO:
			if (inafunc) {
				inafunc = 0;
				func->lines.hi = lastline;
				func->size = n - base - func->begin;
				func->range.hi = n->n_value + relocation;
			}
			// Directory entry
			if (n->n_un.n_name[strlen(n->n_un.n_name)-1] == '/') {
				directory = n->n_un.n_name;
				inasrc = 0;
				break;
			}
			if (!strcmp(n->n_un.n_name, "libg.s")) {
				lgfound = 1;
				inasrc = 0;
				break;
			}
			lastline = 1;
			inasrc = 1;
			lsrc = new SunosSource(this,lsrc,n->n_un.n_name,0);
			hsrc = src = lsrc;
			src->dir = directory;
			suntype = src->typeinfo= new SunosType(src, sunosshare);
			func = 0;
			inafunc = 0;
			ininclude = 0;
			lastsol = 0;
			fst = 0;
			break;
		case N_TEXT|N_EXT:
			if (*n->n_un.n_name == '_')
				++n->n_un.n_name;
			ccdemangle(&n->n_un.n_name);
			if (idtosym(U_FUNC, n->n_un.n_name, 0))
				break;
			func = new Func(this,n->n_un.n_name,0,0);
			func->range.lo = n->n_value + relocation;
			func->_blk = fake;
			t = new DType;
			t->pcc = LONG;
			func->type = t->incref();
			func->type.pcc = FTN;
			break;
		case N_TEXT:
			// if it ends in .o, its a new file
			// need this to mix -g and non -g files
			cp = n->n_un.n_name;
			cp += strlen(cp);
			if (*--cp != 'o' || *--cp != '.')
				break;
			if (inafunc) {
				inafunc = 0;
				func->lines.hi = lastline;
				func->size = n - base - func->begin;
				func->range.hi = n->n_value + relocation;
			}
			inasrc = 0;
			break;
		case N_FUN:
			subtype = strchr(n->n_un.n_name, ':');
			// Sun's unbundled compiler seems to list funcs
			// called from a func with additional N_FUN
			// entries having the same address as calling
			// func. This test throws them away.
			if (subtype && subtype[1] != 'F' && subtype[1] != 'f')
				break;
			if (inafunc) {
				inafunc = 0;
				func->lines.hi = lastline;
				func->size = n - base - func->begin;
				func->range.hi = n->n_value + relocation;
			}
			if (!inasrc || !src)
				break;
			for (n2 = n + 1; n2->n_type != N_SLINE; n2++) {
			  if (n2->n_type == N_SOL) {
				name = n2->n_un.n_name+(long)regstrings;
				if (!strcmp(name, src->_text))
					lastsol = 0;
				else
					lastsol = name;
			  }
			}
			if (lastsol) {
				for (hsrc = lsrc; hsrc;
				     hsrc = (SunosSource*)hsrc->lsib)
					if (!strcmp(lastsol, hsrc->_text))
						break;
				if (!hsrc) {
					hsrc = lsrc = new
					  SunosSource(this,lsrc,lastsol,0);
					hsrc->dir = directory;
				}
			} else
				hsrc = src;
			inafunc = 1;
			ininclude = 0;
			++FunctionStubs;
			*subtype++ = 0;
			name = n->n_un.n_name;
			demangled = ccdemangle(&name);
			func = new Func(this, name, hsrc, n2->n_desc);
			if (demangled) {
				name = n->n_un.n_name;
				ccdemangle(&name, 0, 1);
				func->namewithargs = name;
			}
			func->typeinfo = src;
			func->begin = n - base;
			func->range.lo = n->n_value + relocation;
			t = new DType(suntype->gettype(subtype));
			func->type = t->incref();
			func->type.pcc = FTN;
			// In case long typeinfo is embedded in the entry
			while ((n+1)->n_type == N_FUN)
				n++;
			break;
		}
	}
	if (base) {
		delete [] base;
		base = 0;
	}
	if (!lgfound)
		_warn = "should be linked with ld -g";
	while(lsrc && lsrc->lsib)
		lsrc = (SunosSource*)lsrc->lsib;
	return lsrc;
}

Var *SunosSymTab::gatherutype(UType *ut)
{
	SunosUType *u = (SunosUType*)ut;
	SunosType *typeinfo = ((SunosSource *)u->src)->typeinfo;
	Var *first = 0, *v = 0;
	char *memname, *cp;
	int file, offset;
	int bitsize, bitoffset;
	int isenum = (u->type.pcc == ENUMTY);

	memname = u->encode;
	if (!memname)
		return first;
	++UTypeGathered;
	SymbolStats();
	while (*memname != ';') {
		cp = strchr(memname, ':');
		*cp++ = 0;
		if (isenum) {
			v = new Var( this, 0, v, U_MOT, memname );
			cp = typeinfo->toint(cp, bitsize);
			v->range.lo = bitsize;
			v->type.pcc = MOETY;
			if( !first ) first = v;
			memname = cp + 1;
			continue;
		}
		cp = typeinfo->toindices(cp, file, offset);
		// skip ','
		cp++;
		cp = typeinfo->toint(cp, bitoffset);
		// skip ','
		cp++;
		cp = typeinfo->toint(cp, bitsize);
		v = new Var( this, 0, v, U_MOT, memname );
		v->type = typeinfo->gettype(file, offset);
		if ((bitsize & 0x7) || (bitoffset & 0x7)) {
			v->range.lo = ((bitoffset >> 5) << 5) +
				      32 - bitsize - (bitoffset & 0x1f);
			v->type.pcc = UBITS;
			v->type.dim = bitsize;
		} else
			v->range.lo = bitoffset >> 3;
		if( !first ) first = v;
		memname = cp + 1;
	}
	uncfront(first, u->_text);
	return first;
}

nlist *SunosSymTab::nlistvector(long start, long size )
{
	struct nlist *n;
	int i;

	lseek(fd, symoff + start * sizeof(nlist), 0);
	n = new nlist[size];
	IF_LIVE( !ReadOK(fd, (char*) n, (int)size * sizeof *n) ){
		delete [] n;
		return 0;
	}
	for( i = 0; i < size; ++i )
		n[i].n_un.n_strx += (long) strings;
	return n;
}

SunosTShare::SunosTShare()	{}

SunosTShare::~SunosTShare()
{
	for(SunosTFile *f = file; f < &file[used]; f++) {
		for (int i = 0; i < f->ntypes; i++)
			delete f->type[i];
		delete [] f->type;
	}
	delete [] file;
}

int SunosTShare::addfile(char *fname, long value)
{
	SunosTFile *f;
	int i;

	if (used == nfiles) {		// Grow the number of files
		nfiles += 10;
		f = new SunosTFile[nfiles];
		for (i = 0; i < used; i++)
			f[i] = file[i];
		delete [] file;
		file = f;
	}
	f = &file[used];
	f->fname = fname;		// Initialize
	f->value = value;
	f->ntypes = 30;
	f->type = new DTypep[30];
	f->highest = 0;
	return used++;
}

int SunosTShare::findfile(char *fname, long value)
{
	SunosTFile *f, *e;

	for(f = file, e = &file[used]; f < e; f++) {
		if (!strcmp(f->fname, fname) && value == f->value)
			return f - file;
	}
	return -1;
}

DType *SunosTShare::findtype(int fnum, int offset)
{
	if (offset >= file[fnum].ntypes)
		return 0;
	return file[fnum].type[offset];
}

char *SunosTShare::filename(int fnum)
{
	return file[fnum].fname;
}

void SunosTShare::entertype(int fnum, int offset, DTypep dp)
{
	SunosTFile *f = &file[fnum];
	if (offset >= f->ntypes) {
		int n = offset + 5;	// Room to spare
		DTypepar nda = new DTypep[n];
		for(int i = 0; i < f->ntypes; i++)
			nda[i] = f->type[i];
		delete [] f->type;
		f->type = nda;
		f->ntypes = n;
	}
	f->type[offset] = dp;
	f->highest = offset;
}

SunosType::SunosType(Source *sp, SunosTShare *sh)
{
	share = sh;
	src = sp;
	utypeindex = 0;
	nfiles = 1;
	filemap = new int[nfiles];
	filemap[0] = share->addfile(src->text());
	used = 1;
}

SunosType::~SunosType()
{
	delete [] filemap;
}

void SunosType::addinclude(char *fname, int flg, long value)
{
	if (used == nfiles) {	// More mapping space needed
		nfiles += 10;
		int *map = new int[nfiles];
		for(int i = 0; i < used; i++)
			map[i] = filemap[i];
		delete [] filemap;
		filemap = map;
	}
	if (flg)
		filemap[used] = share->addfile(fname, value);
	else
		filemap[used] = share->findfile(fname, value);
	used++;
}

char *SunosType::backtypeindex(char *s)
{
	s--;
	if (*s == ')') {
		while (*--s != '(')
			;
		return s;
	}
	while(isdigit(*s))
		s--;
	return s+1;
}

struct typemap {
	char *name;
	int type;
};

/*
 * Parse the '=' symbol table information
 * The type index (TI) may of the form:
 *	(int,int) if the compiler supports shared include info (Sun's compilers)
 * or	int	  if the compiler doesn't (gcc)

 * Possiblities:
 *	TI=TI				usually typedefs
 *	TI=*TI				pointers
 *	TI=fTI				functions
 *	TI=arTI;lo;hi;TI		arrays
 *	TI=[Rr]TI;lo;hi;		range
 *	TI=b[su][c]TI;lo;hi;		range
 *	TI=eN:size,...;			enum encoding
 *	TI=sSN:TI,off,size;...;;	structure encoding
 *	TI=uSN:TI,off,size;...;;	union encoding
 *	TI=x{esu}name:			ptr to undefined utype
 */
void SunosType::parsetype(char *equalptr, char *name)
{
	int file, offset;
	int pfile, poffset;
	struct DType *dp, *dp1;
	int ssize;
	char stype;
	char sname[100], *utypename, *to;
	SunosUType *u;
	char *cp2;
	typemap *tm;
	static typemap typemap[] = {
		"char",			CHAR,
		"short",		SHORT,
		"int",			INT,
		"long",			LONG,
		"long long",		LONG,
		"signed char",		CHAR,
		"signed short",		SHORT,
		"signed int",		INT,
		"signed long",		LONG,
		"signed long long",	LONG,
		"unsigned char",	UCHAR,
		"unsigned short",	USHORT,
		"unsigned int",		UNSIGNED,
		"unsigned long",	ULONG,
		"unsigned long long",	ULONG,
		"float",		FLOAT,
		"double",		DOUBLE,
		"long double",		DOUBLE,
		"void",			VOID,
		"long int",		LONG,
		"long unsigned int",	ULONG,
		"short int",		SHORT,
		"long long int",	LONG,
		"short unsigned int",	USHORT,
		"long long unsigned int",	ULONG,
		0,			0
	};

	char *nextequal = strchr(equalptr+1, '=');
	if (nextequal)
		parsetype (nextequal, name);
	register char *tp = equalptr;
	tp = backtypeindex(tp);
	toindices(tp, file, offset);
	register char *cp = equalptr + 1;
	switch (*cp) {
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case '(':
			cp = toindices(cp, pfile, poffset);
			dp1 = share->findtype(pfile,poffset);
			dp = new DType;
			if (!dp1)
				dp->pcc = VOID;
			else {
				dp->pcc = dp1->pcc;
				dp->dim = dp1->dim;
				dp->univ = dp1->univ;
			}
			share->entertype(file, offset, dp);
			break;
		case '*':
			cp = toindices(++cp, pfile, poffset);
			dp = new DType;
			dp->univ = share->findtype(pfile,poffset);
			if (!dp->univ)
				dp->over = (pfile << 16) | poffset;
			dp->pcc = PTR;
			share->entertype(file, offset, dp);
			break;
		case 'f':
			cp = toindices(++cp, pfile, poffset);
			dp = new DType;
			dp->univ = share->findtype(pfile,poffset);
			if (!dp->univ)
				dp->over = (pfile << 16) | poffset;
			dp->pcc = FTN;
			share->entertype(file, offset, dp);
			break;
		case 'a':
			cp = strchr(cp, ';') + 1;
			cp = strchr(cp, ';') + 1;
			dp = new DType;
			cp = toint(cp, dp->dim);
			dp->dim++;
			dp->pcc = ARY;
			cp = strchr(cp, ';') + 1;
			cp = toindices(cp, pfile, poffset);
			dp->univ = share->findtype(pfile,poffset);
			if (!dp->univ)
				dp->over = (pfile << 16) | poffset;
			share->entertype(file, offset, dp);
			break;
		case 'b':
		case 'r':
		case 'R':
			if (!(cp2 = strchr(name, ':')))
				break;
			*cp2 = 0;
			for (tm = typemap; tm->name; tm++)
				if (!strcmp(name, tm->name))
					break;
			dp = new DType;
			if (!tm->name)
				dp->pcc = INT;
			else
				dp->pcc = tm->type;
			share->entertype(file, offset, dp);
			break;
		case 'x':
			stype = *++cp;
			ssize = 0;
			cp++;
			for(to = utypename = sname; *cp != ':'; )
				*to++ = *cp++;
			*to = 0;
			cp++;
			goto xentry;
		case 's': 
		case 'u':
		case 'e':
			utypename = 0;
			if (*--tp == 'T' || *tp == 't') {
				*strchr(name, ':') = 0;
				if (*name && *name != ' ') {
					utypename = name;
					ccdemangle(&utypename);
				}
			}
			if (!utypename) {
				sprintf(sname, "%s.%d",
					basename(share->filename(file)),
					offset);
				utypename = sname;
			}
			stype = *cp++;
			if (stype == 'e')
				ssize = 1;
			else {
				cp = toint(cp, ssize);
				if (!ssize)
					cp++;	// skip ';' following 0
			}
xentry:
			u = (SunosUType*) src->symtab->idtosym(
						U_UTYPE, utypename, 0);
			if( u ){
				if( u->range.lo < ssize ){
					if( u->encode )
						delete [] u->encode;
					u->encode = toutypestr(cp, stype);
					u->range.lo = ssize;
					u->src = src;
				} else if (ssize)
					delete [] toutypestr(cp, stype);
			} else {
				++UTypeStubs;
				if (utypename == sname)
					utypename = sf("%s", sname);
				u = new SunosUType(src->symtab,
				    ssize ? toutypestr(cp, stype) : (char *)0,
				    utypename);
				u->src = src;
				u->range.lo = ssize;
				switch(stype) {
					case 'e':
						u->type.pcc = ENUMTY;
						break;
					case 's':
						u->type.pcc = STRTY;
						break;
					case 'u':
						u->type.pcc = UNIONTY;
						break;
				}
				u->type.univ = u;
				u->rsib = src->symtab->utype;
				src->symtab->utype = u;
			}
			if (!share->findtype(file, offset)) {
				dp = new DType;
				dp->univ = u;
				dp->pcc = u->type.pcc;
				share->entertype(file, offset, dp);
			}
			break;
		default:
			break;
	}
	memset(equalptr, ' ', cp - equalptr);
}

DType SunosType::gettype(char *s)
{
	int file, offset;
	while (*s && *s != '(' && !isdigit(*s))
		s++;
	if (*s)
		toindices(s, file, offset);
	else {
		file = 0;
		offset = 1;
	}
	return gettype(file, offset);
}

DType SunosType::gettype(int fnum, int offset)
{
	return chain(share->findtype(fnum, offset));
}

DType SunosType::chain(DType *dp)
{
	DType d;

	if (!dp) {		// Shouldn't happen - fix this if ever figure
		d.pcc = INT;	// out how the include file references are
		return d;	// shared. I give up ....
	}
	d.pcc = dp->pcc;
	d.dim = dp->dim;
	d.univ = dp->univ;
	if( d.pcc & TMASK ){
		if (!dp->univ)
			dp->univ = share->findtype(dp->over>>16,
					dp->over&0xffff);
		d.univ = new DType;
		*(d.ref()) = chain(dp->ref());
	}
	return d;
}

char *SunosType::toindices(char *cp, int &fnum, int &offset)
{
	if (*cp == '(') {
		// skip '('
		cp++;
		cp = toint(cp, fnum);
		fnum = filemap[fnum];
		// skip ','
		cp++;
		cp = toint(cp, offset);
		// skip  ')'
		cp++;
	} else {
		fnum = filemap[0];
		cp = toint(cp, offset);
	}
	return cp;
}

char *SunosType::toint(char *cp, int &rint)
{
	int sign, cnt = 0;

	if (*cp == '-') {
		sign = -1;
		cp++;
	} else
		sign = 1;
	while (isdigit(*cp))
		cnt = cnt * 10 + *cp++ - '0';
	rint = cnt * sign;
	return cp;
}

char *SunosType::toutypestr(char *cstart, int c)
{
	char *cp, *bp;
	int size;
	register char *to, *from;

	for(cp = cstart, size = 0; ; cp++) {
		if (*cp == '\\') {
			*cp++ = ' ';
			*cp = ' ';
			char *nextequal = strchr(cp+1, '=');
			if (nextequal)
				parsetype(nextequal, nextequal);
		}
		if (*cp != ' ')
			size++;
		if (*cp == ';' && (c == 'e' || *(cp-1) == ';'))
			break;
	}
	to = bp = new char[size + 1];
	from = cstart;
	for (register i = size; size--; ) {
		while (*from == ' ')
			from++;
		*to++ = *from;
		*from++ = ' ';
	}
	*to = 0;
	return bp;
}

SunosSource::SunosSource(SymTab *stab, Source *left, char *t, long c)
 :Source(stab, left, t, c)	{}

SunosUType::SunosUType(SymTab *stab, char *enc, char *id)
 :UType(stab, 0, 0, id)
{
	encode = enc;
}

SunosSource::~SunosSource()	{ delete typeinfo; }
SunosUType::~SunosUType()	{ delete [] encode; }
